package ru.yandex.chemodan.app.psbilling.core.entities.features;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.SynchronizationStatus;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;

@Getter
public class UserServiceFeature extends IssuedFeature<String> {
    public UserServiceFeature(UUID id, Instant createdAt, Target target, Instant targetUpdatedAt,
                              SynchronizationStatus status, Instant statusUpdatedAt, Option<Instant> actualEnabledAt,
                              Option<Instant> actualDisabledAt, UUID userServiceId, UUID productFeatureId,
                              String uid, Option<Instant> nextTry, Option<UUID> productTemplateFeatureId) {
        super(id, createdAt, target, targetUpdatedAt, status, statusUpdatedAt, actualEnabledAt, actualDisabledAt,
                userServiceId, productFeatureId, uid, nextTry, productTemplateFeatureId);
    }

    public UUID getUserServiceId() {
        return getParentServiceId();
    }

    public String getUid() {
        return getOwnerId();
    }
}
