package ru.yandex.chemodan.app.psbilling.core.entities.groups;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.chemodan.app.psbilling.core.entities.groups.billing.BalanceClientType;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.lang.DefaultObject;

@NoArgsConstructor
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class BalancePaymentInfo extends DefaultObject {
    //идентификатор клиента в балансе, который принял оферту, чей контракт и реквизиты мы используем для оплаты
    @JsonProperty("client_id") //TODO remove after migration CHEMODAN-84706
    private Long clientId;
    //uid челоека, который принял оферту, чей контракт и реквизиты мы используем для оплаты
    @JsonProperty("uid") //TODO remove after migration CHEMODAN-84706
    private String clientUid;
    //тип плательщика, с которым заключили контракт (физ лицо или юр лицо)
    @JsonProperty("type") //TODO remove after migration CHEMODAN-84706
    private BalanceClientType clientType;
    //настройка включенности автосписания
    @JsonProperty("b2b_auto_billing_enabled") //TODO remove after migration CHEMODAN-84706
    private boolean b2bAutoBillingEnabled;

    public BalancePaymentInfo(long clientId, PassportUidOrZero clientUid) {
        this(clientId, clientUid.toUid());
    }

    public BalancePaymentInfo(long clientId, PassportUid clientUid) { this(clientId, clientUid, false); }

    public BalancePaymentInfo(long clientId, PassportUid clientUid, boolean b2bAutoBillingEnabled) {
        this(clientId, clientUid, BalanceClientType.LEGAL_PERSON, b2bAutoBillingEnabled);
    }

    public BalancePaymentInfo(long clientId, PassportUid clientUid, BalanceClientType clientType) {
        this(clientId, clientUid, clientType, false);
    }

    public BalancePaymentInfo(long clientId, PassportUid clientUid, BalanceClientType clientType, boolean b2bAutoBillingEnabled) {
        this.clientId = clientId;
        this.clientUid = clientUid.toString();
        this.clientType = clientType;
        this.b2bAutoBillingEnabled = b2bAutoBillingEnabled;
    }

    @JsonIgnore
    public BalancePaymentInfo withB2bAutoBillingEnabled(boolean b2bAutoBillingEnabled) {
        this.b2bAutoBillingEnabled = b2bAutoBillingEnabled;
        return this;
    }

    @Deprecated
    public BalancePaymentInfo(long clientId, String clientUid) {
        this(clientId, PassportUid.cons(Long.parseLong(clientUid)));
    }

    @JsonIgnore
    public PassportUid getPassportUid() {
        return PassportUid.cons(Long.parseLong(clientUid));
    }

    @JsonIgnore
    @Deprecated
    public String getClientUid() {
        return clientUid;
    }
}
