package ru.yandex.chemodan.app.psbilling.core.entities.groups;

import java.util.UUID;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntityWithIdEqHash;
import ru.yandex.inside.passport.PassportUid;

@Getter
@ToString
public class Group extends AbstractEntityWithIdEqHash {
    private final GroupType type;
    private final String externalId;
    private final PassportUid ownerUid;
    @Getter(value = AccessLevel.NONE)
    @ToString.Exclude
    private final Function0<Option<BalancePaymentInfo>> paymentInfoSupplier;
    private final Instant updatedAt;
    private final GroupStatus status;
    private final Option<Duration> gracePeriod;
    private final boolean synchronizationStopped;
    private final Instant membersNextSyncDt;
    private final Option<String> clid;
    private final Option<UUID> parentGroupId;
    @Getter(value = AccessLevel.NONE)
    @ToString.Exclude
    private final Function0<Option<Group>> parentGroupSupplier;
    @Getter(value = AccessLevel.NONE)
    @ToString.Exclude
    private final Function0<ListF<Group>> childGroupsSupplier;

    public Group(UUID id, Instant createdAt, GroupType type, String externalId,
                 PassportUid ownerUid, Function0<Option<BalancePaymentInfo>> paymentInfo, Instant updatedAt, GroupStatus status,
                 Option<Duration> gracePeriod, boolean synchronizationStopped, Instant membersNextSyncDt,
                 Option<String> clid, Option<UUID> parentGroupId, Function0<Option<Group>> parentGroupSupplier,
                 Function0<ListF<Group>> childGroupsSupplier)
    {
        super(id, createdAt);
        this.type = type;
        this.externalId = externalId;
        this.ownerUid = ownerUid;
        this.paymentInfoSupplier = paymentInfo;
        this.updatedAt = updatedAt;
        this.status = status;
        this.gracePeriod = gracePeriod;
        this.synchronizationStopped = synchronizationStopped;
        this.membersNextSyncDt = membersNextSyncDt;
        this.clid = clid;
        this.parentGroupId = parentGroupId;
        this.parentGroupSupplier = parentGroupSupplier;
        this.childGroupsSupplier = childGroupsSupplier;
    }

    public Option<BalancePaymentInfo> getPaymentInfoWithUidBackwardCompatibility() {
        //изначатльно в объекте мог не быть uid, но он есть на группе, и его нужно использовать с группы,
        // если его нет на  paymentInfo
        Option<BalancePaymentInfo> paymentInfoO = paymentInfoSupplier.apply();
        if (!paymentInfoO.isPresent()) {
            return Option.empty();
        }

        BalancePaymentInfo existing = paymentInfoO.get();
        if (!StringUtils.isBlank(existing.getClientUid())) {
            return paymentInfoO;
        } else {
            return Option.of(new BalancePaymentInfo(existing.getClientId(), ownerUid.toString()));
        }
    }

    public Option<BalancePaymentInfo> getPaymentInfo() {
        return paymentInfoSupplier.apply();
    }

    public Option<Group> getParentGroup() {
        return parentGroupSupplier.apply();
    }

    public ListF<Group> getChildGroups() {
        return childGroupsSupplier.apply();
    }
}
