package ru.yandex.chemodan.app.psbilling.core.entities.groups;

import java.math.BigDecimal;
import java.util.Currency;
import java.util.UUID;

import lombok.Builder;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntityWithIdEqHash;

@Getter
public class GroupProductEntity extends AbstractEntityWithIdEqHash {
    private final String code;
    private final UUID userProductId;
    private final BigDecimal pricePerUserInMonth;
    private final Currency priceCurrency;
    private final Option<String> balanceProductName;
    private final boolean singleton;
    private final boolean skipTransactionsExport;
    private final Option<UUID> trialDefinitionId;
    private final Option<Instant> availableTo;
    private final boolean hidden;
    private final Option<UUID> titleTankerKeyId;
    private final boolean isBestOffer;
    private final GroupPaymentType paymentType;
    private final Option<BigDecimal> displayOriginalPrice;
    private final GroupProductType productType;
    private final Option<BigDecimal> displayDiscountPercent;

    @Builder(toBuilder = true)
    public GroupProductEntity(UUID id, Instant createdAt, String code, UUID userProductId, Option<String> balanceProductName,
                              BigDecimal pricePerUserInMonth, Currency priceCurrency, boolean singleton, boolean skipTransactionsExport,
                              Option<UUID> trialDefinitionId, Option<Instant> availableTo, boolean hidden, Option<UUID> titleTankerKeyId, boolean isBestOffer,
                              GroupPaymentType paymentType, Option<BigDecimal> displayOriginalPrice,
                              GroupProductType productType, Option<BigDecimal> displayDiscountPercent)
    {
        super(id, createdAt);
        this.code = code;
        this.userProductId = userProductId;
        this.balanceProductName = balanceProductName;
        this.pricePerUserInMonth = pricePerUserInMonth;
        this.priceCurrency = priceCurrency;
        this.singleton = singleton;
        this.skipTransactionsExport = skipTransactionsExport;
        this.trialDefinitionId = trialDefinitionId;
        this.availableTo = availableTo;
        this.hidden = hidden;
        this.titleTankerKeyId = titleTankerKeyId;
        this.isBestOffer = isBestOffer;
        this.paymentType = paymentType;
        this.displayOriginalPrice = displayOriginalPrice;
        this.productType = productType;
        this.displayDiscountPercent = displayDiscountPercent;
    }
}
