package ru.yandex.chemodan.app.psbilling.core.entities.groups;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.SynchronizableRecord;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.SynchronizationStatus;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;

@Getter
public class GroupService extends SynchronizableRecord {
    private final UUID groupId;
    private final UUID groupProductId;
    private final Instant updatedAt;
    // дата следующей проверки состояния сервиса
    // для организаций, работющих по постоплате, и билящихся в балансе, у нас эта дата постоянно передвигается,
    // и мы постоянно проверяем состояния их лицевого счета в балансе. если пользователь ожидает платежа, или залочен
    // то также дата сдвигается постоянно
    // для предоплатных услуг, дата является датой предполагаемого опустошения кошелька
    private final Option<Instant> nextBillingDate;
    private final Option<String> deduplicationKey;
    private final Option<Instant> firstFeatureDisabledAt;
    private final boolean skipTransactionsExport;
    private final boolean hidden;


    public GroupService(UUID id, Instant createdAt, Instant updatedAt, Target target, Instant targetUpdatedAt,
                        SynchronizationStatus status, Instant statusUpdatedAt, Option<Instant> actualEnabledAt,
                        Option<Instant> actualDisabledAt, UUID groupId, UUID groupProductId,
                        Option<Instant> nextBillingDate,
                        Option<String> deduplicationKey, Option<Instant> firstFeatureDisabledAt,
                        boolean skipTransactionsExport, boolean hidden) {
        super(id, createdAt, target, targetUpdatedAt, status, statusUpdatedAt, actualEnabledAt, actualDisabledAt);
        this.groupId = groupId;
        this.groupProductId = groupProductId;
        this.updatedAt = updatedAt;
        this.nextBillingDate = nextBillingDate;
        this.deduplicationKey = deduplicationKey;
        this.firstFeatureDisabledAt = firstFeatureDisabledAt;
        this.skipTransactionsExport = skipTransactionsExport;
        this.hidden = hidden;
    }
}
