package ru.yandex.chemodan.app.psbilling.core.entities.groups;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.SynchronizableRecord;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.SynchronizationStatus;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;

@Getter
public class GroupServiceMember extends SynchronizableRecord {
    private final UUID groupServiceId;
    private final String uid;
    private final Option<UUID> userServiceId;


    public GroupServiceMember(UUID id, Instant createdAt,
            Target target, Instant targetUpdatedAt,
            SynchronizationStatus status, Instant statusUpdatedAt,
            Option<Instant> actualEnabledAt, Option<Instant> actualDisabledAt, UUID groupServiceId, String uid,
            Option<UUID> userServiceId)
    {
        super(id, createdAt, target, targetUpdatedAt, status, statusUpdatedAt, actualEnabledAt, actualDisabledAt);
        this.groupServiceId = groupServiceId;
        this.uid = uid;
        this.userServiceId = userServiceId;
    }
}
