package ru.yandex.chemodan.app.psbilling.core.entities.groups;

import java.math.BigDecimal;
import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;

@Getter
public class GroupServicePriceOverride extends AbstractEntity {
    private UUID groupServiceId;
    private BigDecimal pricePerUserInMonth;
    private Instant startDate;
    private Option<Instant> endDate;
    private Option<UUID> trialUsageId;
    private PriceOverrideReason reason;
    private boolean hidden;

    public GroupServicePriceOverride(UUID id, Instant createdAt, UUID groupServiceId, BigDecimal pricePerUserInMonth,
            Instant startDate, Option<Instant> endDate, Option<UUID> trialUsageId, PriceOverrideReason reason,
            boolean hidden)
    {
        super(id, createdAt);
        this.groupServiceId = groupServiceId;
        this.pricePerUserInMonth = pricePerUserInMonth;
        this.startDate = startDate;
        this.endDate = endDate;
        this.trialUsageId = trialUsageId;
        this.reason = reason;
        this.hidden = hidden;
    }

    public boolean isFree() {
        return pricePerUserInMonth.compareTo(BigDecimal.ZERO) <= 0;
    }
}
