package ru.yandex.chemodan.app.psbilling.core.entities.groups;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

public enum GroupStatus implements StringEnum {
    ACTIVE("active", 0),
    PAYMENT_REQUIRED("payment_required", 1),
    DEBT_EXISTS("debt_exists", 2);

    private final String value;

    private final int priority;

    GroupStatus(String value, int priority) {
        this.value = value;
        this.priority = priority;
    }

    @Override
    public String value() {
        return value;
    }

    public int getPriority() {
        return priority;
    }

    public static final StringEnumResolver<GroupStatus> R = StringEnumResolver.r(GroupStatus.class);
}
