package ru.yandex.chemodan.app.psbilling.core.entities.groups;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

public enum GroupType implements StringEnum {
    ORGANIZATION("organization", false),
    ORGANIZATION_USER("organization_user", true),
    FAMILY("family", false),
    STAFF("staff", false);

    private final String value;

    public boolean isSubgroup() {
        return isSubgroup;
    }

    private final boolean isSubgroup;

    GroupType(String value, boolean isSubgroup) {
        this.value = value;
        this.isSubgroup = isSubgroup;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<GroupType> R = StringEnumResolver.r(GroupType.class);

}
