package ru.yandex.chemodan.app.psbilling.core.entities.groups;

import java.math.BigDecimal;
import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.CustomPeriod;

@Getter
public class TrialDefinitionEntity extends AbstractEntity {
    private final TrialType type;
    private final boolean hidden;
    private final BigDecimal price;
    private final Option<Instant> endDate; //for TrialType = UNTIL_DATE
    private final Option<CustomPeriod> duration; //for TrialType = CONSTANT_PERIOD
    private final Option<String> singleUsageComparisonKey;


    public TrialDefinitionEntity(UUID id, Instant createdAt, TrialType type, boolean hidden, BigDecimal price,
            Option<Instant> endDate, Option<CustomPeriod> duration, Option<String> singleUsageComparisonKey)
    {
        super(id, createdAt);
        this.type = type;
        this.hidden = hidden;
        this.price = price;
        this.endDate = endDate;
        this.duration = duration;
        this.singleUsageComparisonKey = singleUsageComparisonKey;
    }
}
