package ru.yandex.chemodan.app.psbilling.core.entities.groups;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;
import ru.yandex.inside.passport.PassportUid;

@Getter
public class TrialUsage extends AbstractEntity {
    private final Option<UUID> groupId;
    private final Option<PassportUid> activatedByUid;
    private final UUID trialDefinitionId;
    private final Instant startDate;
    private final Instant endDate;

    public TrialUsage(UUID id, Instant createdAt, Option<UUID> groupId, Option<PassportUid> activatedByUid,
                       UUID trialDefinitionId,Instant startDate, Instant endDate) {
        super(id, createdAt);
        this.groupId = groupId;
        this.activatedByUid = activatedByUid;
        this.trialDefinitionId = trialDefinitionId;
        this.startDate = startDate;
        this.endDate = endDate;
    }
}
