package ru.yandex.chemodan.app.psbilling.core.entities.groups.billing;

import java.math.BigDecimal;
import java.util.Currency;
import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;

@Getter
public class ClientBalanceEntity extends AbstractEntity {
    private final Long clientId;
    private final BigDecimal balanceAmount;
    private final Currency balanceCurrency;
    private final Option<Instant> balanceVoidAt;
    private final Option<Instant> lastInvoiceAt;
    private final Instant balanceUpdatedAt;

    public ClientBalanceEntity(UUID id, Instant createdAt, Instant balanceUpdatedAt, Long clientId,
                               BigDecimal balanceAmount,
                               String balanceCurrency, Option<Instant> balanceVoidAt,
                               Option<Instant> lastInvoiceAt) {
        super(id, createdAt);
        this.balanceUpdatedAt = balanceUpdatedAt;
        this.clientId = clientId;
        this.balanceAmount = balanceAmount;
        this.balanceCurrency = Currency.getInstance(balanceCurrency);
        this.balanceVoidAt = balanceVoidAt;
        this.lastInvoiceAt = lastInvoiceAt;
    }
}
