package ru.yandex.chemodan.app.psbilling.core.entities.groups.billing;

import java.math.BigDecimal;
import java.util.Currency;
import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;

@Getter
public class DistributionPlatformTransactionEntity extends AbstractEntity {
    private final LocalDate calcMonth;
    private final UUID groupId;
    private final BigDecimal paidUserCount;
    private final BigDecimal amount;
    private final Currency currency;
    private final String clid;
    private final String actId;

    public DistributionPlatformTransactionEntity(UUID id, Instant createdAt, LocalDate calcMonth, UUID groupId,
                                                 BigDecimal paidUserCount, BigDecimal amount, Currency currency, String clid,
                                                 String actId) {
        super(id, createdAt);
        this.calcMonth = calcMonth;
        this.groupId = groupId;
        this.paidUserCount = paidUserCount;
        this.amount = amount;
        this.currency = currency;
        this.clid = clid;
        this.actId = actId;
    }
}
