package ru.yandex.chemodan.app.psbilling.core.entities.groups.billing;

import java.math.BigDecimal;
import java.util.Currency;
import java.util.UUID;

import lombok.Builder;
import lombok.Getter;
import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.misc.lang.DefaultObject;

@Getter
public class GroupServiceTransaction extends DefaultObject {
    private final LocalDate billingDate;
    private final UUID groupServiceId;
    private final BigDecimal amount;
    private final Currency currency;
    private final BigDecimal userSecondsCount;
    private final Instant calculatedAt;

    @Builder(toBuilder = true)
    public GroupServiceTransaction(LocalDate billingDate, UUID groupServiceId, BigDecimal amount,
                                   Currency currency, BigDecimal userSecondsCount, Instant calculatedAt) {
        this.billingDate = billingDate;
        this.groupServiceId = groupServiceId;
        this.amount = amount;
        this.currency = currency;
        this.userSecondsCount = userSecondsCount;
        this.calculatedAt = calculatedAt;
    }
}
