package ru.yandex.chemodan.app.psbilling.core.entities.groups.billing;

import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.SneakyThrows;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupServiceWrapper;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class GroupTrustPaymentGroupServiceInfo extends DefaultObject {
    @JsonProperty("activate_services")
    private ActivateServiceInfo[] activateServices;

    public GroupTrustPaymentGroupServiceInfo(ListF<GroupServiceWrapper> services) {
        MapF<UUID, ListF<GroupServiceWrapper>> servicesByGroups =
                services.groupBy(GroupServiceWrapper::getGroupId);
        ListF<ActivateServiceInfo> result = Cf.arrayList();
        for (UUID groupId : servicesByGroups.keys()) {
            Product[] products = servicesByGroups.getTs(groupId).map(x -> new Product(x.getGroupProduct().getCode()))
                    .toArray(Product.class);
            result.add(new ActivateServiceInfo(groupId, products));
        }
        this.activateServices = result.toArray(ActivateServiceInfo.class);
    }

    @Override
    @SneakyThrows
    public String toString() {
        return new ObjectMapper().writeValueAsString(this);
    }


    @Getter
    @AllArgsConstructor
    @NoArgsConstructor
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class ActivateServiceInfo extends DefaultObject {
        @JsonProperty("group_id")
        private UUID groupId;
        @JsonProperty("products")
        private Product[] products;
    }

    @Getter
    @AllArgsConstructor
    @NoArgsConstructor
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Product extends DefaultObject {
        @JsonProperty("code")
        private String code;
    }
}

