package ru.yandex.chemodan.app.psbilling.core.entities.groups.billing;

import java.util.Objects;
import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.Money;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;

@Getter
public class GroupTrustPaymentRequest extends AbstractEntity {
    private final String requestId;
    private final PaymentRequestStatus status;
    private final Option<String> error;
    private final Option<String> transactionId;
    private final String operatorUid;
    private final PaymentInitiationType paymentInitiationType;
    private final Long clientId;
    private final Option<Double> paymentPeriodCoefficient;
    private final Option<GroupTrustPaymentGroupServiceInfo> groupServicesInfo;
    private final Option<UUID> cardId;
    private final Option<Money> money;

    public GroupTrustPaymentRequest(UUID id, Instant createdAt, String requestId,
                                    PaymentRequestStatus status, Option<String> error, Option<String> transactionId,
                                    String operatorUid,
                                    PaymentInitiationType paymentInitiationType, Long clientId,
                                    Option<Double> paymentPeriodCoefficient,
                                    Option<GroupTrustPaymentGroupServiceInfo> groupServicesInfo,
                                    Option<UUID> cardId, Option<Money> money) {
        super(id, createdAt);
        this.requestId = requestId;
        this.status = status;
        this.error = error;
        this.transactionId = transactionId;
        this.operatorUid = operatorUid;
        this.paymentInitiationType = paymentInitiationType;
        this.clientId = clientId;
        this.paymentPeriodCoefficient = paymentPeriodCoefficient;
        this.groupServicesInfo = groupServicesInfo;
        this.cardId = cardId;
        this.money = money;
    }

    public GroupTrustPaymentRequest withStatus(PaymentRequestStatus status) {
        return Objects.equals(this.status, status)
                ? this
                : new GroupTrustPaymentRequest(
                this.id,
                this.createdAt,
                this.requestId,
                status,
                this.error,
                this.transactionId,
                this.operatorUid,
                this.paymentInitiationType,
                this.clientId,
                this.paymentPeriodCoefficient,
                this.groupServicesInfo,
                this.cardId,
                this.money
        );
    }

    public GroupTrustPaymentRequest withError(Option<String> error) {
        return this.error.isMatch(error::isSome) || (this.error.isEmpty() && error.isEmpty())
                ? this
                : new GroupTrustPaymentRequest(
                this.id,
                this.createdAt,
                this.requestId,
                this.status,
                error,
                this.transactionId,
                this.operatorUid,
                this.paymentInitiationType,
                this.clientId,
                this.paymentPeriodCoefficient,
                this.groupServicesInfo,
                this.cardId,
                this.money
        );
    }
}
