package ru.yandex.chemodan.app.psbilling.core.entities.products;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

public enum BillingType implements StringEnum {
    TRUST("trust"),
    INAPP_GOOGLE("inapp_google"),
    INAPP_APPLE("inapp_apple"),
    //    MEDIABILLING("mediabilling"),
    FREE("free"),
    GROUP("group");

    private String value;

    BillingType(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<BillingType> R = StringEnumResolver.r(BillingType.class);

    public boolean isInappProduct() {
        return this == INAPP_APPLE || this == INAPP_GOOGLE;
    }

    public String getTrustProductType(boolean autoprolong) {
        if (!this.isInappProduct() && this != BillingType.TRUST) {
            throw new IllegalStateException(this.toString());
        }

        if (!autoprolong) {
            return "app";
        }

        if (this.isInappProduct()) {
            return "inapp_subs";
        } else if (this == BillingType.TRUST) {
            return "subs";
        }

        throw new IllegalStateException(this.toString());
    }
}
