package ru.yandex.chemodan.app.psbilling.core.entities.products;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;
import ru.yandex.chemodan.app.psbilling.core.util.RequestTemplate;

@Getter
public class FeatureEntity extends AbstractEntity {
    private final String code;
    private final Option<Integer> systemTvmId;
    private final FeatureType type;
    private final String description;
    private final Option<RequestTemplate> activationRequestTemplate;
    private final Option<RequestTemplate> setAmountRequestTemplate;
    private final Option<RequestTemplate> deactivationRequestTemplate;
    private final Instant updatedAt;
    private final boolean callSetAmountOnActivation;
    private final boolean callSetAmountOnDeactivation;
    private final String errorProcessorName;

    @Builder(toBuilder = true)
    public FeatureEntity(UUID id, Instant createdAt, Instant updatedAt,
            String code, Option<Integer> systemTvmId,
            FeatureType type,
            String description, Option<RequestTemplate> activationRequestTemplate,
            Option<RequestTemplate> setAmountRequestTemplate,
            Option<RequestTemplate> deactivationRequestTemplate, boolean callSetAmountOnActivation,
            boolean callSetAmountOnDeactivation, String errorProcessorName)
    {
        super(id, createdAt);
        this.code = code;
        this.systemTvmId = systemTvmId;
        this.type = type;
        this.description = description;
        this.activationRequestTemplate = activationRequestTemplate;
        this.setAmountRequestTemplate = setAmountRequestTemplate;
        this.deactivationRequestTemplate = deactivationRequestTemplate;
        this.updatedAt = updatedAt;
        this.callSetAmountOnActivation = callSetAmountOnActivation;
        this.callSetAmountOnDeactivation = callSetAmountOnDeactivation;
        this.errorProcessorName = errorProcessorName;
    }

}
