package ru.yandex.chemodan.app.psbilling.core.entities.products;

import java.math.BigDecimal;
import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;

@Getter
public class ProductFeatureEntity extends AbstractEntity {
    private final Option<UUID> featureId; // if feature on product only for visibility
    private final UUID userProductId;
    private final BigDecimal amount;
    private final boolean enabled;
    private final int orderNum;
    private final Option<UUID> descriptionTankerKeyId;
    private final Option<UUID> groupTankerKeyId;
    private final Option<UUID> valueTankerKeyId;
    private final String code;
    private final FeatureScope scope;

    public ProductFeatureEntity(UUID id, Instant createdAt, Option<UUID> featureId, UUID userProductId,
                                BigDecimal amount, boolean enabled, int orderNum,
                                Option<UUID> descriptionTankerKeyId,
                                Option<UUID> groupTankerKeyId,
                                Option<UUID> valueTankerKeyId,
                                String code, FeatureScope applicationType)
    {
        super(id, createdAt);
        this.featureId = featureId;
        this.userProductId = userProductId;
        this.amount = amount;
        this.enabled = enabled;
        this.orderNum = orderNum;
        this.descriptionTankerKeyId = descriptionTankerKeyId;
        this.groupTankerKeyId = groupTankerKeyId;
        this.valueTankerKeyId = valueTankerKeyId;
        this.code = code;
        this.scope = applicationType;
    }
}
