package ru.yandex.chemodan.app.psbilling.core.entities.products;

import java.util.Comparator;
import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;

@Getter
public class ProductLineEntity extends AbstractEntity {
    private final UUID productSetId;
    private final int orderNum;
    private final String selectorBeanEL;
    private final Option<String> description;

    public ProductLineEntity(UUID id, Instant createdAt, UUID productSetId, String selectorBeanEL, int orderNum, String description) {
        super(id, createdAt);
        this.productSetId = productSetId;
        this.orderNum = orderNum;
        this.selectorBeanEL = selectorBeanEL;
        this.description = Option.ofNullable(description);
    }

    public static Comparator<ProductLineEntity> topWithPromoThenByOrderNum(MapF<UUID, ?> promos) {
        return ProductLineEntity
                .topWithPromo(promos)
                .thenComparing(ProductLineEntity.byOrderNum());
    }
    public static Comparator<ProductLineEntity> topWithPromo(MapF<UUID, ?> promos) {
        return Comparator.comparing(x -> !promos.containsKeyTs(x.getId()));
    }

    public static Comparator<ProductLineEntity> byOrderNum() {
        return Comparator.comparing(ProductLineEntity::getOrderNum);
    }
}
