package ru.yandex.chemodan.app.psbilling.core.entities.products;

import java.math.BigDecimal;
import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;

/**
 * @author friendlyevil
 */
@Getter
public class ProductTemplateFeatureEntity extends AbstractEntity {
    private final UUID productTemplateId;
    private final Option<UUID> featureId; // if feature on product only for visibility
    private final BigDecimal amount;
    private final Option<UUID> descriptionTankerKeyId;
    private final Option<UUID> groupTankerKeyId;
    private final Option<UUID> valueTankerKeyId;
    private final boolean enabled;
    private final int orderNum;
    private final String code;


    public ProductTemplateFeatureEntity(UUID id, Instant createdAt, UUID productTemplateId, Option<UUID> featureId,
                                        BigDecimal amount, boolean enabled, int orderNum,
                                        Option<UUID> descriptionTankerKeyId, Option<UUID> groupTankerKeyId,
                                        Option<UUID> valueTankerKeyId, String code) {
        super(id, createdAt);
        this.productTemplateId = productTemplateId;
        this.featureId = featureId;
        this.amount = amount;
        this.enabled = enabled;
        this.orderNum = orderNum;
        this.descriptionTankerKeyId = descriptionTankerKeyId;
        this.groupTankerKeyId = groupTankerKeyId;
        this.valueTankerKeyId = valueTankerKeyId;
        this.code = code;
    }

}
