package ru.yandex.chemodan.app.psbilling.core.entities.products;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;

@Getter
public class UserProductBucketEntity extends AbstractEntity {
    private final String code;
    private final Option<UUID> userProductId;
    private final Option<UUID> productLineId;
    private final Option<UUID> productSetId;

    public UserProductBucketEntity(UUID id, Instant createdAt, String code, Option<UUID> userProductId,
            Option<UUID> productLineId, Option<UUID> productSetId)
    {
        super(id, createdAt);
        this.code = code;
        this.userProductId = userProductId;
        this.productLineId = productLineId;
        this.productSetId = productSetId;
    }
}
