package ru.yandex.chemodan.app.psbilling.core.entities.products;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;

@Getter
public class UserProductEntity extends AbstractEntity {
    private final Option<UUID> titleTankerKeyId;
    private final String code;
    private final String codeFamily;
    private final BillingType billingType;
    private final boolean allowAutoProlong;
    private final boolean isBestOffer;
    private final UUID productOwnerId;
    private final Option<Instant> availableFrom;
    private final Option<Integer> trustServiceId;

    /**
     * 1D, 1M, 666Y
     * https://wiki.yandex-team.ru/TRUST/Payments/API/Subscriptions/#mnogokratnyepopytkispisanijasraznicejjvneskolkochasovvtecheniegrejjs-perioda
     */
    private final Option<String> trustSubsGracePeriod;
    /**
     * 1D, 1M, 666Y
     */
    private final Option<String> trustSubsChargingRetryDelay;
    /**
     * 1D, 1M, 666Y
     */
    private final Option<String> trustSubsChargingRetryLimit;

    private final Option<UUID> trialDefinitionId;

    public UserProductEntity(UUID id, Instant createdAt, Option<UUID> titleTankerKeyId, Option<Integer> trustServiceId,
                             String code, String codeFamily, BillingType billingType, boolean isBestOffer,
                             UUID productOwnerId,
                             Option<Instant> availableFrom, boolean allowAutoProlong,
                             Option<String> trustSubsGracePeriod,
                             Option<String> trustSubsChargingRetryDelay, Option<String> trustSubsChargingRetryLimit,
                             Option<UUID> trialDefinitionId)
    {
        super(id, createdAt);
        this.titleTankerKeyId = titleTankerKeyId;
        this.code = code;
        this.codeFamily = codeFamily;
        this.billingType = billingType;
        this.isBestOffer = isBestOffer;
        this.productOwnerId = productOwnerId;
        this.availableFrom = availableFrom;
        this.allowAutoProlong = allowAutoProlong;
        this.trustSubsGracePeriod = trustSubsGracePeriod;
        this.trustSubsChargingRetryDelay = trustSubsChargingRetryDelay;
        this.trustSubsChargingRetryLimit = trustSubsChargingRetryLimit;
        this.trustServiceId = trustServiceId;
        this.trialDefinitionId = trialDefinitionId;
    }
}
