package ru.yandex.chemodan.app.psbilling.core.entities.products;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.CustomPeriod;

@Getter
public class UserProductPeriodEntity extends AbstractEntity {
    private final String code;
    private final CustomPeriod period;
    private final UUID userProductId;
    private final Option<String> trustFiscalTitle;
    private final Option<String> packageName;
    private final Option<CustomPeriod> startPeriodDuration;
    private final Option<Integer> startPeriodCount;

    public UserProductPeriodEntity(UUID id, Instant createdAt, String code, CustomPeriod period,
                                   UUID userProductId, Option<String> trustFiscalTitle, Option<String> packageName,
                                   Option<CustomPeriod> startPeriodDuration, Option<Integer> startPeriodCount) {
        super(id, createdAt);
        this.code = code;
        this.period = period;
        this.userProductId = userProductId;
        this.trustFiscalTitle = trustFiscalTitle;
        this.packageName = packageName;
        this.startPeriodDuration = startPeriodDuration;
        this.startPeriodCount = startPeriodCount;
    }
}
