package ru.yandex.chemodan.app.psbilling.core.entities.products;

import java.math.BigDecimal;
import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;

@Getter
public class UserProductPriceEntity extends AbstractEntity {

    private final UUID userProductPeriodId;
    private final String regionId;
    private final BigDecimal price;
    private final String currencyCode;
    private final Option<BigDecimal> displayDiscountPercent;
    private final Option<BigDecimal> displayOriginalPrice;
    private final Option<BigDecimal> startPeriodPrice;

    public UserProductPriceEntity(UUID id, Instant createdAt, UUID userProductPeriodId, String regionId,
            BigDecimal price, String currencyCode, Option<BigDecimal> displayDiscountPercent,
            Option<BigDecimal> displayOriginalPrice, Option<BigDecimal> startPeriodPrice) {
        super(id, createdAt);
        this.userProductPeriodId = userProductPeriodId;
        this.regionId = regionId;
        this.price = price;
        this.currencyCode = currencyCode;
        this.displayDiscountPercent = displayDiscountPercent;
        this.displayOriginalPrice = displayOriginalPrice;
        this.startPeriodPrice = startPeriodPrice;
    }
}
