package ru.yandex.chemodan.app.psbilling.core.entities.promocodes;

import java.util.UUID;

import lombok.Getter;
import lombok.ToString;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.UsedPromoCode;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntityWithIdEqHash;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.SafePromoCode;
import ru.yandex.inside.passport.PassportUid;

@Getter
@ToString
public class GroupPromoCodeActivationEntity extends AbstractEntityWithIdEqHash implements UsedPromoCode {
    private final SafePromoCode code;
    private final PassportUid uid;
    private final UUID groupId;
    private final UUID groupPromoId;

    public GroupPromoCodeActivationEntity(
            UUID id,
            Instant createdAt,
            SafePromoCode code,
            PassportUid uid,
            UUID groupId,
            UUID groupPromoId
    ) {
        super(id, createdAt);
        this.code = code;
        this.uid = uid;
        this.groupId = groupId;
        this.groupPromoId = groupPromoId;
    }
}
