package ru.yandex.chemodan.app.psbilling.core.entities.promocodes;

import java.util.UUID;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.SafePromoCode;

@Data
@EqualsAndHashCode(onlyExplicitlyIncluded = true)
public class PromoCodeEntity {
    @EqualsAndHashCode.Include
    private final SafePromoCode code;
    @Deprecated
    private final Option<UUID> userProductPriceId;
    @Deprecated
    private final Option<UUID> promoTemplateId;
    @Deprecated
    private final Option<Integer> numActivations;
    private final Option<Integer> remainingActivations;
    private final PromoCodeStatus status;
    private final Instant statusUpdatedAt;
    private final Option<String> statusReason;
    @Deprecated
    private final Instant fromDate;
    @Deprecated
    private final Option<Instant> toDate;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final PromoCodeType type;
    private final Option<String> templateCode;
}
