package ru.yandex.chemodan.app.psbilling.core.entities.promocodes;

import java.util.UUID;

import lombok.Getter;
import lombok.ToString;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.UsedPromoCode;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntityWithIdEqHash;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.SafePromoCode;
import ru.yandex.inside.passport.PassportUid;


@Getter
@ToString
public class UserPromoCodeEntity extends AbstractEntityWithIdEqHash implements UsedPromoCode {
    private final SafePromoCode code;
    private final PassportUid uid;
    private final Option<UUID> orderId;
    private final Option<UUID> userPromoId;

    public UserPromoCodeEntity(
            UUID id,
            Instant createdAt,
            SafePromoCode code,
            PassportUid uid,
            Option<UUID> orderId,
            Option<UUID> userPromoId
    ) {
        super(id, createdAt);
        this.code = code;
        this.uid = uid;
        this.orderId = orderId;
        this.userPromoId = userPromoId;
    }
}
