package ru.yandex.chemodan.app.psbilling.core.entities.promos;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

public enum PromoApplicationArea implements StringEnum {
    /**
     * Для обратной совместимости.
     */
    GLOBAL("global"),
    /**
     * Всем в b2с
     */
    GLOBAL_B2C("global_b2c"),
    /**
     * На пользователя
     */
    PER_USER("per_user"),
    /**
     * Всем в b2b
     */
    GLOBAL_B2B("global_b2b"),
    /**
     * На группу
     */
    PER_GROUP("per_group");
    private final String value;

    PromoApplicationArea(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<PromoApplicationArea> R = StringEnumResolver.r(PromoApplicationArea.class);

    public static final ListF<PromoApplicationArea> b2cList = Cf.list(GLOBAL, GLOBAL_B2C, PER_USER);

    public static final ListF<PromoApplicationArea> b2bList = Cf.list(GLOBAL_B2B, PER_GROUP);
}
