package ru.yandex.chemodan.app.psbilling.core.entities.promos;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;

@Getter
public class PromoPayloadEntity extends AbstractEntity {
    public static final int DEFAULT_VERSION = 1;

    private final UUID promoId;
    private final String payloadType;
    private final int version;
    private final String content;

    public PromoPayloadEntity(UUID id, UUID promoId, String payloadType, String content, int version,
                              Instant createdAt) {
        super(id, createdAt);
        this.promoId = promoId;
        this.payloadType = payloadType;
        this.version = version;
        this.content = content;
    }
}
