package ru.yandex.chemodan.app.psbilling.core.entities.promos;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.CustomPeriod;
import ru.yandex.chemodan.util.date.DateTimeUtils;

@Getter
public class PromoTemplateEntity extends AbstractEntity {
    private final String description;
    private final String code;
    private final Instant fromDate;
    private final Option<Instant> toDate;
    private final PromoApplicationArea applicationArea;
    private final PromoApplicationType applicationType;
    private final Option<CustomPeriod> duration;
    private final Option<String> activationEmailTemplate;
    private final Option<UUID> promoNameTankerKey;

    public PromoTemplateEntity(UUID id, Instant createdAt, String code,
                               String description,
                               Instant fromDate,
                               Option<Instant> toDate,
                               PromoApplicationArea applicationArea,
                               PromoApplicationType applicationType,
                               Option<CustomPeriod> duration,
                               Option<String> activationEmailTemplate,
                               Option<UUID> promoNameTankerKey) {
        super(id, createdAt);
        this.code = code;
        this.description = description;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.applicationArea = applicationArea;
        this.applicationType = applicationType;
        this.duration = duration;
        this.activationEmailTemplate = activationEmailTemplate;
        this.promoNameTankerKey = promoNameTankerKey;
    }

    public boolean isActive() {
        return DateTimeUtils.isNowInRange(Option.of(fromDate), toDate);
    }

    public boolean isActiveInFuture() {
        return toDate.isEmpty() || toDate.get().isAfterNow();
    }
}
