package ru.yandex.chemodan.app.psbilling.core.entities.promos;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;
import ru.yandex.chemodan.util.date.DateTimeUtils;
import ru.yandex.inside.passport.PassportUid;

@Getter
public class UserPromoEntity extends AbstractEntity {
    private final UUID promoTemplateId;
    private final PassportUid uid;
    private final Instant fromDate;
    private final Option<Instant> toDate;
    private final PromoStatusType status;
    private final Instant updatedAt;

    public boolean isActive() {
        return status == PromoStatusType.ACTIVE && DateTimeUtils.isNowInRange(Option.of(fromDate), toDate);
    }

    public boolean isActiveInFuture() {
        return status == PromoStatusType.ACTIVE && (toDate.isEmpty() || toDate.get().isAfterNow());
    }

    public UserPromoEntity(UUID id, Instant createdAt, UUID promoTemplateId, PassportUid uid, Instant fromDate,
                           Option<Instant> toDate, PromoStatusType status, Instant updatedAt) {
        super(id, createdAt);
        this.promoTemplateId = promoTemplateId;
        this.uid = uid;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.status = status;
        this.updatedAt = updatedAt;
    }
}
