package ru.yandex.chemodan.app.psbilling.core.entities.promos.group;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.UsedPromoTemplate;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;
import ru.yandex.chemodan.util.date.DateTimeUtils;

@Getter
public class GroupPromoEntity extends AbstractEntity implements UsedPromoTemplate {
    private final UUID promoTemplateId;
    private final UUID groupId;
    private final Instant fromDate;
    private final Option<Instant> toDate;
    private final GroupPromoStatusType status;
    private final Instant updatedAt;

    public GroupPromoEntity(
            UUID id,
            Instant createdAt,
            UUID promoTemplateId,
            UUID groupId,
            Instant fromDate,
            Option<Instant> toDate,
            GroupPromoStatusType status,
            Instant updatedAt
    ) {
        super(id, createdAt);
        this.promoTemplateId = promoTemplateId;
        this.groupId = groupId;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.status = status;
        this.updatedAt = updatedAt;
    }

    public boolean isActive() {
        return status == GroupPromoStatusType.ACTIVE && DateTimeUtils.isNowInRange(Option.of(fromDate), toDate);
    }

    public boolean isActiveInFuture() {
        return status == GroupPromoStatusType.ACTIVE && (toDate.isEmpty() || toDate.get().isAfterNow());
    }
}
