package ru.yandex.chemodan.app.psbilling.core.entities.users;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;

@Getter
public class Order extends AbstractEntity {
    private final UUID userProductPriceId;
    private final Option<UUID> userServiceId;
    private final String uid;
    private final OrderStatus status;
    private final OrderType type;
    private final String trustOrderId;
    private final int subscriptionsCount;
    private final Option<String> trustErrorCode;
    private final Option<String> trustErrorMessage;
    private final Integer trustServiceId;
    private final Option<String> packageName;
    private final Option<UUID> upgradedOrderIdTo;
    private final Option<Instant> inappSynchronizationDate;

    private final Instant updatedAt;

    public Order(UUID id, Instant createdAt, UUID userProductPriceId, Option<UUID> userServiceId, String uid,
                 OrderStatus status, OrderType type, String trustOrderId, int subscriptionsCount, Instant updatedAt,
                 Option<String> trustErrorCode, Option<String> trustErrorMessage, Integer trustServiceId,
                 Option<String> packageName, Option<UUID> upgradedOrderIdTo, Option<Instant> inappSynchronizationDate)
    {
        super(id, createdAt);
        this.userProductPriceId = userProductPriceId;
        this.userServiceId = userServiceId;
        this.uid = uid;
        this.status = status;
        this.type = type;
        this.trustOrderId = trustOrderId;
        this.subscriptionsCount = subscriptionsCount;
        this.trustErrorCode = trustErrorCode;
        this.trustErrorMessage = trustErrorMessage;
        this.updatedAt = updatedAt;
        this.trustServiceId = trustServiceId;
        this.packageName = packageName;
        this.upgradedOrderIdTo = upgradedOrderIdTo;
        this.inappSynchronizationDate = inappSynchronizationDate;
    }
}
