package ru.yandex.chemodan.app.psbilling.core.entities.users;

import java.util.List;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

public enum OrderStatus implements StringEnum {
    INIT("init"),
    PAID("paid"),
    ON_HOLD("on_hold"),
    UPGRADED("upgraded"),
    ERROR("error");

    private String value;

    OrderStatus(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<OrderStatus> R = StringEnumResolver.r(OrderStatus.class);

    /**
     * Состояния из которых нет возврата в init
     */
    public static final List<OrderStatus> TERMINAL_STATUSES = Cf.list(PAID, UPGRADED)
            .unmodifiable();
}
