package ru.yandex.chemodan.app.psbilling.core.entities.users;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;

@Getter
public class Refund extends AbstractEntity {
    private Instant updatedAt;
    private UUID orderId;
    private String trustPaymentId;
    private String trustRefundId;
    private RefundStatus status;

    public Refund(UUID id, Instant createdAt, Instant updatedAt, UUID orderId,
            String trustPaymentId, String trustRefundId,
            RefundStatus status)
    {
        super(id, createdAt);
        this.updatedAt = updatedAt;
        this.orderId = orderId;
        this.trustPaymentId = trustPaymentId;
        this.trustRefundId = trustRefundId;
        this.status = status;
    }
}
