package ru.yandex.chemodan.app.psbilling.core.entities.users;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

public enum RefundStatus implements StringEnum {
    INIT("init"),
    SUCCESS("success"),
    ERROR("error"), //unknown error, retry is prohibited
    FAILED("failed"); // retry allowed

    public static final SetF<RefundStatus> FINAL_STATUSES = Cf.set(SUCCESS, FAILED);
    private final String value;

    RefundStatus(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<RefundStatus> R = StringEnumResolver.r(RefundStatus.class);

}
