package ru.yandex.chemodan.app.psbilling.core.entities.users;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.SynchronizableRecord;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.SynchronizationStatus;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;

@Getter
public class UserServiceEntity extends SynchronizableRecord {
    private final UUID userProductId;
    private final String uid;
    private final Option<Instant> nextCheckDate;
    private final Option<Instant> dueDate;
    private final Instant updatedAt;
    private final Option<Instant> firstFeatureDisabledAt;
    private final Option<UUID> productPriceId;
    private final Option<Boolean> autoProlongEnabled;
    private final Option<UserServiceBillingStatus> billingStatus;
    private final Option<UUID> lastPaymentOrderId;
    private final Option<String> packageName;

    public UserServiceEntity(UUID id, Instant createdAt, Instant updatedAt, Target target, Instant targetUpdatedAt,
            SynchronizationStatus status, Instant statusUpdatedAt, Option<Instant> actualEnabledAt,
            Option<Instant> actualDisabledAt, UUID userProductId, String uid,
            Option<Instant> nextCheckDate, Option<Instant> dueDate,
            Option<Instant> firstFeatureDisabledAt, Option<UUID> productPriceId, Option<Boolean> autoProlongEnabled,
            Option<UserServiceBillingStatus> billingStatus, Option<UUID> lastPaymentOrderId, Option<String> packageName)
    {
        super(id, createdAt, target, targetUpdatedAt, status, statusUpdatedAt, actualEnabledAt, actualDisabledAt);
        this.userProductId = userProductId;
        this.uid = uid;
        this.nextCheckDate = nextCheckDate;
        this.dueDate = dueDate;
        this.updatedAt = updatedAt;
        this.firstFeatureDisabledAt = firstFeatureDisabledAt;
        this.productPriceId = productPriceId;
        this.autoProlongEnabled = autoProlongEnabled;
        this.billingStatus = billingStatus;
        this.lastPaymentOrderId = lastPaymentOrderId;
        this.packageName = packageName;
    }
}
