package ru.yandex.chemodan.app.psbilling.core.groups;

import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupService;
import ru.yandex.chemodan.app.psbilling.core.products.GroupProduct;
import ru.yandex.chemodan.app.psbilling.core.products.GroupProductManager;

public class GroupServiceWrapper extends GroupService {
    private final ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupService entity;
    private final Function0<GroupProduct> groupProductProvider;

    public GroupServiceWrapper(GroupService entity,
                               GroupProduct groupProduct) {
        this(entity, () -> groupProduct);
    }

    public GroupServiceWrapper(GroupService entity,
                               GroupProductManager groupProductManager) {
        this(entity, () -> groupProductManager.findById(entity.getGroupProductId()));
    }

    public GroupServiceWrapper(GroupService entity, Function0<GroupProduct> groupProductProvider) {
        super(entity.getId(), entity.getCreatedAt(), entity.getUpdatedAt(), entity.getTarget(),
                entity.getTargetUpdatedAt(), entity.getStatus(), entity.getStatusUpdatedAt(),
                entity.getActualEnabledAt(), entity.getActualDisabledAt(), entity.getGroupId(),
                entity.getGroupProductId(), entity.getNextBillingDate(), entity.getDeduplicationKey(),
                entity.getFirstFeatureDisabledAt(), entity.isSkipTransactionsExport(), entity.isHidden());
        this.entity = entity;
        this.groupProductProvider = groupProductProvider.memoize();
    }

    public UUID getGroupId() {
        return entity.getGroupId();
    }

    public UUID getGroupProductId() {
        return entity.getGroupProductId();
    }

    public Instant getUpdatedAt() {
        return entity.getUpdatedAt();
    }

    public Option<Instant> getNextBillingDate() {
        return entity.getNextBillingDate();
    }

    public Option<String> getDeduplicationKey() {
        return entity.getDeduplicationKey();
    }

    public Option<Instant> getFirstFeatureDisabledAt() {
        return entity.getFirstFeatureDisabledAt();
    }

    public boolean getSkipTransactionsExport() {
        return entity.isSkipTransactionsExport();
    }

    public boolean isHidden() {
        return entity.isHidden();
    }

    public GroupProduct getGroupProduct() {
        return groupProductProvider.apply();
    }
}
