package ru.yandex.chemodan.app.psbilling.core.groups;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.products.GroupProduct;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@Builder(toBuilder = true)
@AllArgsConstructor
public class SubscriptionContext extends DefaultObject {
    private final GroupProduct product;
    private final Group group;
    private final PassportUid uid;
    private final Option<String> deduplicationKey;
    private final boolean isEduGroup;
    private final Option<UsedPromoData> usedPromo;
    private final boolean sendEmail;

    public SubscriptionContext(
            GroupProduct product,
            Group group,
            PassportUid uid,
            Option<String> deduplicationKey,
            boolean isEduGroup,
            UsedPromoData usedPromoData) {
        this(product, group, uid, deduplicationKey, isEduGroup, Option.of(usedPromoData), true);
    }

    public SubscriptionContext(
            GroupProduct product,
            Group group,
            PassportUid uid,
            Option<String> deduplicationKey,
            boolean isEduGroup) {
        this(product, group, uid, deduplicationKey, isEduGroup, Option.empty(), true);
    }

    @Data
    public static class UsedPromoData {
        private final ListF<String> productExperiments;
    }
}
