package ru.yandex.chemodan.app.psbilling.core.mail;

import java.util.UUID;

import lombok.Builder;
import lombok.Data;
import lombok.Setter;
import lombok.With;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.InappStore;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.email.Email;

@BenderBindAllFields
@Data
@Builder
public class MailContext {

    @With
    private final PassportUid to;

    @With
    @Builder.Default
    private final Option<Email> email = Option.empty();

    @Builder.Default
    private final ListF<String> groupIds = Cf.list();

    @Builder.Default
    private final ListF<GroupServiceData> groupServices = Cf.list();

    @Builder.Default
    private final Option<String> userServiceId = Option.empty();

    @Setter
    @Builder.Default
    private Option<Language> language = Option.empty();

    @Builder.Default
    private final Option<UUID> promoId = Option.empty();

    @Builder.Default
    private final Option<UUID> userPromoId = Option.empty();

    @Builder.Default
    private final Option<UUID> userProductId = Option.empty();

    @Builder.Default
    private final Option<UUID> oldUserProductId = Option.empty();

    @Builder.Default
    private final Option<LocalDate> balanceVoidDate = Option.empty();

    @Builder.Default
    private final Option<String> cardName = Option.empty();

    @Builder.Default
    private final Option<UUID> userProductPriceId = Option.empty();

    @Builder.Default
    private final Option<InappStore> inappStore = Option.empty();

    public Language getLanguageOrThrow() {
        return language.orElseThrow(() -> new IllegalStateException("Missing language"));
    }

    public String getDistinctRecipient() {
        return email.map(Email::getEmail).orElseGet(to::toString);
    }
}
