package ru.yandex.chemodan.app.psbilling.core.mail;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.model.SenderContext;
import ru.yandex.chemodan.web.JacksonPojo;

@AllArgsConstructor
@Data
public class SenderRequestBody implements JacksonPojo {

    @JsonProperty("args")
    private MapF<String, Object> args;

    @JsonProperty
    private ListF<Attachment> attachments;

    public SenderRequestBody(SenderContext senderContext) {
        this.args = senderContext.getArgs();
        this.attachments = senderContext.getAttachments();
    }
}
