package ru.yandex.chemodan.app.psbilling.core.mail;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.entities.CustomPeriod;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.model.SenderTemplateDefinition;
import ru.yandex.commune.dynproperties.DynamicProperty;

public class Utils {

    private static final String BALANCE_EMAIL_DELIMITER = ";";

    public static final String DELIMITER = ":";

    public static SenderTemplateDefinition parseTemplateDefinition(String value) {
        if (!value.contains(DELIMITER)) {
            throw new IllegalStateException(String.format("No delimiter in the template definition value='%s', " +
                    "delimiter='%s'", value, DELIMITER));
        }
        String[] values = value.split(":");
        if (values.length != 2) {
            throw new IllegalStateException(String.format("Too many parts value='%s'", value));
        }
        return new SenderTemplateDefinition(values[0], values[1]);
    }

    public static String parseFirstEmailFromBalance(String email) {
        if (!email.contains(BALANCE_EMAIL_DELIMITER)) {
            return email;
        }
        return email.split(BALANCE_EMAIL_DELIMITER)[0];
    }

    public static boolean validateCustomPeriod(String value) {
        try {
            CustomPeriod.fromString(value).toJodaPeriod().toStandardDuration();
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public static Duration toDuration(DynamicProperty<String> durationProperty) {
        return CustomPeriod.fromString(durationProperty.get()).toJodaPeriod().toStandardDuration();
    }

    private Utils() {}
}
