package ru.yandex.chemodan.app.psbilling.core.mail.configuration;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.psbilling.core.mail.tasks.BaseEmailTask;
import ru.yandex.commune.dynproperties.DynamicProperty;

@AllArgsConstructor
public class GlobalMailConfiguration {
    private final DynamicProperty<Boolean> isEnabled = new DynamicProperty<>(
            "ps-billing-emails-enabled", Boolean.TRUE);
    private final DynamicProperty<ListF<Long>> enabledForUids = new DynamicProperty<>(
            "ps-billing-emails-enabled-for-uids", Cf.list());
    private final DynamicProperty<ListF<String>> disabledEvents = new DynamicProperty<>(
            "ps-billing-emails-disabled-events", Cf.list());

    public boolean isEmailsEnabled() {
        return isEnabled.get();
    }

    public ListF<Long> uidsListEnabled() {
        return enabledForUids.get();
    }

    public boolean isTaskEnabled(BaseEmailTask.Parameters parameters) {
        return isEmailsEnabled()
                && !uidsListEnabled().exists(uidLong -> uidLong.equals(parameters.getContext().getTo().toUidOrZero().getUid()))
                && parameters != null
                && !disabledEvents.get().containsTs(parameters.getEmailKey());
    }
}
