package ru.yandex.chemodan.app.psbilling.core.mail.dataproviders;

import java.util.UUID;

import com.google.common.base.Preconditions;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductOwner;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupsManager;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.model.SenderTemplateDefinition;
import ru.yandex.chemodan.app.psbilling.core.products.UserProduct;
import ru.yandex.chemodan.app.psbilling.core.texts.TankerTranslation;
import ru.yandex.chemodan.app.psbilling.core.users.UserService;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.utils.Language;

public abstract class AbstractPochtaProSenderDataProvider extends AbstractSenderDataProvider {

    private final UserServiceManager userServiceManager;

    public AbstractPochtaProSenderDataProvider(Blackbox2 blackbox2, GroupsManager groupsManager,
            UserServiceManager userServiceManager)
    {
        super(blackbox2, groupsManager);
        this.userServiceManager = userServiceManager;
    }

    @Override
    public Option<SenderTemplateDefinition> selectMailTemplateDefinition(MailContext mailContext) {
        checkMailContextPreconditions(mailContext);
        UserProduct userProduct = userServiceManager
                .findById(mailContext.getUserServiceId().map(UUID::fromString).get())
                .getUserProduct();
        ProductOwner productOwner = userProduct.getProductOwner();
        if (!MAIL_PRODUCT_OWNER_CODE.equals(productOwner.getCode())) {
            return Option.empty();
        }
        return super.selectMailTemplateDefinition(mailContext);
    }

    protected String getTariffName(UserService userService, Language language) {
        UserProduct product = userService.getUserProduct();
        TankerTranslation title = product.getTitle().getOrThrow("No tanker data for user product");
        return title.findLanguageTranslation(language.value())
                .getOrThrow("No translation " + product.getCode() + " title to " + language);
    }

    protected UserServiceManager getUserServiceManager() {
        return userServiceManager;
    }

    protected void checkMailContextPreconditions(MailContext mailContext) {
        Preconditions.checkArgument(mailContext.getUserServiceId().isPresent(), "No user services in context");
    }
}
