package ru.yandex.chemodan.app.psbilling.core.mail.dataproviders;

import ru.yandex.chemodan.app.psbilling.core.balance.BalanceService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupBillingService;
import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupStatus;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupsManager;
import ru.yandex.chemodan.app.psbilling.core.mail.EventMailType;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;
import ru.yandex.chemodan.app.psbilling.core.mail.localization.DateResolver;
import ru.yandex.chemodan.app.psbilling.core.mail.localization.TermsResolver;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

import static ru.yandex.chemodan.app.psbilling.core.mail.Utils.DELIMITER;

public class BecameFreeSenderDataProvider extends AbstractCheckDebtsSenderDataProvider {

    private final DynamicProperty<String> senderTemplateDefinition =
            new DynamicProperty<>("ps-billing-transactional-emails-became-free-template-definition",
                    "disk" + DELIMITER + "KDBURSN3-CQA1");

    public BecameFreeSenderDataProvider(GroupDao groupDao, DateResolver dateResolver,
                                        Blackbox2 blackbox2, GroupBillingService groupBillingService,
                                        BalanceService balanceService,
                                        TermsResolver termsResolver, GroupsManager groupsManager,
                                        FeatureFlags featureFlags) {
        super(groupDao, dateResolver, blackbox2, groupBillingService, balanceService, termsResolver, groupsManager,
                featureFlags);
    }

    @Override
    protected GroupStatus getValidBillingStatus() {
        return GroupStatus.DEBT_EXISTS;
    }

    @Override
    public boolean isAcceptableFor(EventMailType eventMailType, MailContext context) {
        return EventMailType.BECAME_FREE.equals(eventMailType);
    }

    @Override
    protected DynamicProperty<String> getRuSenderTemplate() {
        return senderTemplateDefinition;
    }
}
