package ru.yandex.chemodan.app.psbilling.core.mail.dataproviders;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.mail.EventMailType;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.model.SenderContext;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.model.SenderTemplateDefinition;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.utils.Language;


public interface SenderDataProvider {

    Option<SenderContext> buildSenderContext(MailContext mailContext);

    Option<SenderTemplateDefinition> selectMailTemplateDefinition(MailContext mailContext);

    boolean isAcceptableFor(EventMailType eventMailType, MailContext context);

    Option<Language> getLanguage(PassportUid uid);
}
