package ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders;

import java.util.function.Function;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;

@AllArgsConstructor
public class CardNameKeyDataProvider extends BaseEmailKeyDataProvider {

    @Override
    protected MapF<String, Function<MailContext, Option<String>>> constructHandlers() {
        return Cf.map("card_name", this::getCardName);
    }

    private Option<String> getCardName(MailContext context) {
        return context.getCardName();
    }
}
