package ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders;

import java.util.function.Function;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;
import ru.yandex.chemodan.domenator.DomainInfo;
import ru.yandex.chemodan.domenator.DomainStatus;
import ru.yandex.chemodan.domenator.DomenatorClient;

@AllArgsConstructor
public class DomainsKeyDataProvider extends BaseEmailKeyDataProvider {
    private final DomenatorClient domenatorClient;
    private final static SetF<DomainStatus> ACTIVE_DOMAIN_STATUSES =
            Cf.set(DomainStatus.PENDING_REGISTRAR, DomainStatus.WAIT_DNS_ENTRIES, DomainStatus.REGISTERED);

    @Override
    protected MapF<String, Function<MailContext, Option<String>>> constructHandlers() {
        return Cf.map("beautiful_email_exists", this::existsBeautifulEmail);
    }

    private Option<String> existsBeautifulEmail(MailContext mailContext) {
        Option<DomainInfo> domainInfo = domenatorClient.getUserDomainInfo(mailContext.getTo());
        return Option.of(domainInfo.map(d -> ACTIVE_DOMAIN_STATUSES.containsTs(d.getStatus())).orElse(false))
                .map(Object::toString);
    }
}
