package ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders;

import java.util.function.Function;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.InappStore;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;

@AllArgsConstructor
public class InappStoreNameKeyDataProvider extends BaseEmailKeyDataProvider {

    @Override
    protected MapF<String, Function<MailContext, Option<String>>> constructHandlers() {
        return Cf.map("inapp_store_type", this::getStoreName);
    }

    private Option<String> getStoreName(MailContext context) {
        return context.getInappStore().map(InappStore::getHumanReadable);
    }
}
